﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class ForegroundFlashCount : UserControl,IControl,ICorrespondenceOS
    {
        private ForegroundFlashCountController foregroundFlashCountController;

        public ForegroundFlashCount()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,       
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG                                       
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetForegroundFlashCountState(int i)
        {
            textBox1.Text = i.ToString();
        }


        public int GetForegroundFlashCountState()
        {
            return Convert.ToInt32(textBox1.Text);
        }

        #region IControl メンバ

        public void Apply()
        {
            foregroundFlashCountController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return foregroundFlashCountController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void ForegroundFlashCount_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            foregroundFlashCountController = new ForegroundFlashCountController(this,
                                                                    (IForegroundFlashCountStrategy)
                                                                    wfUtillity.
                                                                        GetCorrespondenceInstance
                                                                        (new List<ICorrespondenceOS>
                                                                             {
                                                                                 new ForegroundFlashCountDefaultStrategy()
                                                                             }));
            foregroundFlashCountController.Read();
        }
    }
}
